<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'gender', 'email', 'email_status', 'phone', 'phone_status', 'address', 'level', 'type', 'identity', 'nationality');

    public function arbitrator()
    {
        return $this->hasOne('App/Models\Arbitrator', 'user_id');
    }

    public function country()
    {
        return $this->hasOne('App/Models\Country', 'country_id');
    }

}